<?php

function getUserIP()
{
    // Get the IP address of the user
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    return $ip;
}

function getIPLocation($ip)
{
    $url = "http://ipinfo.io/{$ip}/json";
    $json = file_get_contents($url);
    return json_decode($json, true);
}

function getBrowserAndOS()
{
    $userAgent = $_SERVER['HTTP_USER_AGENT'];

    // Get browser name
    if (strpos($userAgent, 'Firefox') !== false) {
        $browser = 'Mozilla Firefox';
    } elseif (strpos($userAgent, 'Chrome') !== false) {
        $browser = 'Google Chrome';
    } elseif (strpos($userAgent, 'Safari') !== false && strpos($userAgent, 'Chrome') === false) {
        $browser = 'Safari';
    } elseif (strpos($userAgent, 'MSIE') !== false || strpos($userAgent, 'Trident') !== false) {
        $browser = 'Internet Explorer';
    } elseif (strpos($userAgent, 'Edge') !== false) {
        $browser = 'Microsoft Edge';
    } else {
        $browser = 'Unknown Browser';
    }

    // Get operating system name
    if (strpos($userAgent, 'Windows NT 10.0') !== false) {
        $os = 'Windows 10';
    } elseif (strpos($userAgent, 'Windows NT 6.3') !== false) {
        $os = 'Windows 8.1';
    } elseif (strpos($userAgent, 'Windows NT 6.2') !== false) {
        $os = 'Windows 8';
    } elseif (strpos($userAgent, 'Windows NT 6.1') !== false) {
        $os = 'Windows 7';
    } elseif (strpos($userAgent, 'Mac OS X') !== false) {
        $os = 'Mac OS X';
    } elseif (strpos($userAgent, 'Linux') !== false) {
        $os = 'Linux';
    } elseif (strpos($userAgent, 'Android') !== false) {
        $os = 'Android';
    } elseif (strpos($userAgent, 'iPhone') !== false) {
        $os = 'iOS (iPhone)';
    } elseif (strpos($userAgent, 'iPad') !== false) {
        $os = 'iOS (iPad)';
    } else {
        $os = 'Unknown OS';
    }

    return ['browser' => $browser, 'os' => $os];
}
